//--------------------------------------------------------------------
/*	@file
	@brief	DirectX ff֘A

	DirectXDiagReport.h
	DirectX ff֘A

	@author	
	@date	t
	$Revision: $
*/
//--------------------------------------------------------------------

//--------------------------------------------------------------------
// CN[h
//--------------------------------------------------------------------
#define _CRT_SECURE_NO_DEPRECATE // warning C4996:
#include <windows.h>
#include <dxdiag.h>
#include "DirectXDiagReport.h"

//--------------------------------------------------------------------
// }N
//--------------------------------------------------------------------
#define EXPAND( x )			x, sizeof( x ) / sizeof( TCHAR )

//--------------------------------------------------------------------
// \
//--------------------------------------------------------------------

//--------------------------------------------------------------------
// OQƊ֐vg^Cv錾
//--------------------------------------------------------------------

//--------------------------------------------------------------------
// QƊ֐vg^Cv錾
//--------------------------------------------------------------------

//--------------------------------------------------------------------
// OQƕϐvg^Cv錾
//--------------------------------------------------------------------

//--------------------------------------------------------------------
// Qƕϐ
//--------------------------------------------------------------------
CDirectXDiagReport *CDirectXDiagReport::mInstance = NULL;		//!< CX^X

//--------------------------------------------------------------------
/*!
	RXgN^
	@param[in]		
	@return			
	@note			
*/
//--------------------------------------------------------------------
CDirectXDiagReport::CDirectXDiagReport()
	:	mDxDiagProvider( NULL ),
		mDxDiagRoot( NULL ),
		mIsEnable( FALSE )
{

}

//--------------------------------------------------------------------
/*!
	fXgN^
	@param[in]		
	@return			
	@note			
*/
//--------------------------------------------------------------------
CDirectXDiagReport::~CDirectXDiagReport()
{

}

//--------------------------------------------------------------------
/*!
	DirectX _CAÕCX^X쐬
	@param[in]		Ȃ
	@return			Ȃ^
	@note			
*/
//--------------------------------------------------------------------
void CDirectXDiagReport::CreateInstance( void )
{
	// CX^X쐬
	mInstance = new CDirectXDiagReport;
}

//--------------------------------------------------------------------
/*!
	DirectX _CAÕCX^X
	@param[in]		Ȃ
	@return			
	@note			
*/
//--------------------------------------------------------------------
void CDirectXDiagReport::DeleteInstance( void )
{
	// 
	delete mInstance;
	mInstance = NULL;
}

//--------------------------------------------------------------------
/*!
	DirectX _CAȌ
	@param[in]		Ȃ
	@return			Ȃ^
	@note			
*/
//--------------------------------------------------------------------
BOOL CDirectXDiagReport::Initialize( void )
{
	HRESULT		aRet;

	// 쐬
	aRet = CoCreateInstance( 
		CLSID_DxDiagProvider,
		NULL,
		CLSCTX_INPROC_SERVER,
		IID_IDxDiagProvider,
		( LPVOID*)&mDxDiagProvider
	);
	// s
	if( FAILED( aRet ) ){
		MessageBox( NULL, "IDxDiagProvider ̍쐬Ɏs܂B\nf[^̍ו擾o܂łB", "WORNING", MB_OK );
		return ( 0x00 );
	}

	// Fill out a DXDIAG_INIT_PARAMS struct and pass it to IDxDiagContainer::Initialize
	// Passing in TRUE for bAllowWHQLChecks, allows dxdiag to check if drivers are 
	// digital signed as logo'd by WHQL which may connect via internet to update 
	// WHQL certificates.    
	DXDIAG_INIT_PARAMS dxDiagInitParam;
	memset( &dxDiagInitParam, 0, sizeof( DXDIAG_INIT_PARAMS ) );

	// p[^Zbg
	dxDiagInitParam.dwSize					= sizeof( DXDIAG_INIT_PARAMS );
	dxDiagInitParam.dwDxDiagHeaderVersion	= DXDIAG_DX9_SDK_VERSION;
	dxDiagInitParam.bAllowWHQLChecks		= FALSE;
	dxDiagInitParam.pReserved				= NULL;

	// 擾Ə
	aRet = mDxDiagProvider->Initialize( &dxDiagInitParam );
	// s
	if( FAILED( aRet ) ){
		MessageBox( NULL, "m_pDxDiagProvider->Initialize ֐s܂B\nf[^̍ו擾o܂łB", "WORNING", MB_OK );
		return ( 0x00 );
	}
	// 
	aRet = mDxDiagProvider->GetRootContainer( &mDxDiagRoot );
	// s
	if( FAILED( aRet ) ){
		MessageBox( NULL, "m_pDxDiagProvider->GetRootContaine ֐s܂B\nf[^̍ו擾o܂łB", "WORNING", MB_OK );
		return ( 0x00 );
	}

	// 
	mIsEnable = TRUE;

	// Ԃ
	return ( TRUE );
}

//--------------------------------------------------------------------
/*!
	DirectX _CAỎ
	@param[in]		
	@return			
	@note			
*/
//--------------------------------------------------------------------
void CDirectXDiagReport::Terminate( void )
{
	// 
	if( mDxDiagProvider != NULL ){
		mDxDiagProvider->Release();
		mDxDiagProvider = NULL;
	}
	// 
	if( mDxDiagRoot != NULL ){
		mDxDiagRoot->Release();
		mDxDiagRoot = NULL;
	}
}

//--------------------------------------------------------------------
/*!
	DirectX _CAȌ擾
	@param[in]		*d_dialog_p		_CAO\
	@return			
	@note			
*/
//--------------------------------------------------------------------
void CDirectXDiagReport::GetInfomation( void )
{
	// \
	WCHAR				wszContainer[ 256];
	IDxDiagContainer	*pContainer			= NULL;
	IDxDiagContainer	*pObject			= NULL;
	DWORD				nInstanceCount		= 0;
	DWORD				nItem				= 0;
	HRESULT				aRet;

    // Get the IDxDiagContainer object called "DxDiag_SystemInfo".
    // This call may take some time while dxdiag gathers the info.
    aRet = mDxDiagRoot->GetChildContainer( L"DxDiag_SystemInfo", &pObject );
    if( FAILED( aRet ) || pObject == NULL ){

		// 
	}

	//--------------------------------------
	// 擾
	// DirectX Version
	// CPU 
	aRet = GetStringValue( pObject, L"szOSExEnglish", EXPAND( mStrOsName ) );
	aRet = GetStringValue( pObject, L"szPhysicalMemoryEnglish", EXPAND( mStrMemoryTotal ) );
	aRet = GetStringValue( pObject, L"szPageFileEnglish", EXPAND( mStrMemoryUse ) );
	aRet = GetStringValue( pObject, L"szDirectXVersionLongEnglish", EXPAND( mStrDirectXVersion ) );
	aRet = GetStringValue( pObject, L"szProcessorEnglish", EXPAND( mStrCpuInfo ) );

	// 
	if( pObject != NULL ){
		pObject->Release();
		pObject = NULL;
	}

	// Get the IDxDiagContainer object called "DxDiag_DisplayDevices".
	// This call may take some time while dxdiag gathers the info.
	if( FAILED( aRet = mDxDiagRoot->GetChildContainer( L"DxDiag_DisplayDevices", &pContainer ) ) ){}
	if( FAILED( aRet = pContainer->GetNumberOfChildContainers( &nInstanceCount ) ) ){}

	// 
	for( nItem = 0; nItem < nInstanceCount; nItem++ ){

		// 擾
		aRet = pContainer->EnumChildContainerNames( nItem, wszContainer, 256 );
		aRet = pContainer->GetChildContainer( wszContainer, &pObject );
		if( FAILED( aRet ) || pObject == NULL ){
			break;
		}

		// 擾
		// VRAM ̃TCY
		aRet = GetStringValue( pObject, L"szDisplayMemoryLocalized", EXPAND( mStrVramSize ) );
		// OtBbN{[h
		aRet = GetStringValue( pObject, L"szDescription", EXPAND( mStrDescription ) );
		// hCo[
		aRet = GetStringValue( pObject, L"szDriverName", EXPAND( mStrDriver ) );
		// hCo[̃o[W
		aRet = GetStringValue( pObject, L"szDriverVersion", EXPAND( mStrDriverVersion ) );
		// hCo[̓t
		aRet = GetStringValue( pObject, L"szDriverDateLocalized", EXPAND( mStrDriverDate ) );

		// 
		if( pObject != NULL ){
			pObject->Release();
			pObject = NULL;
		}
	}

	// 
	if( pContainer != NULL ){
		pContainer->Release();
		pContainer = NULL;
	}
}

//--------------------------------------------------------------------
/*!

	@param[in]
	@return			
	@note			
*/
//--------------------------------------------------------------------
HRESULT CDirectXDiagReport::GetStringValue( IDxDiagContainer *pObject, WCHAR *wstrName, TCHAR *strValue, int nStrLen )
{
    HRESULT		aRet;
    VARIANT		var;
    VariantInit( &var );

	// 擾
	if( FAILED( aRet = pObject->GetProp( wstrName, &var ) ) ){

		// s
        return ( aRet );
	}

	// f[^ł͂Ȃ
	if( var.vt != VT_BSTR ){

		// s
		return ( E_INVALIDARG );
	}
    
#ifdef _UNICODE
    wcsncpy( strValue, var.bstrVal, ( nStrLen - 1 ) );
#else
    wcstombs( strValue, var.bstrVal, nStrLen );   
#endif
    strValue[ ( nStrLen - 1 )] = TEXT('\0');
    VariantClear( &var );

    return ( S_OK );
}

/*--------------------------------------------------------------------
	DirectXDiagReport.cpp		End of File
----------------------------------------------------------------------*/
